import argparse
import sys
import json
import yaml


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("resource_upload_info", nargs='+')
    parser.add_argument("--deploy_conf", default="deploy/{{cookiecutter.project_name}}.yaml", required=False)
    args = parser.parse_args()

    deploy_conf = yaml.load(open(args.deploy_conf))

    for upload_info_path in args.resource_upload_info:
        with open(upload_info_path) as fd:
            ya_upload_output = json.load(fd)

        resource_name = ya_upload_output['file_name']
        resource_url = ya_upload_output['skynet_id']
        resource_md5 = ya_upload_output['md5']

        resources = {
            resource_entry['id']: resource_entry for resource_entry in
            deploy_conf['spec']['deploy_units']['{{cookiecutter.project_name}}']['multi_cluster_replica_set'][
             'replica_set']['pod_template_spec']['spec']['pod_agent_payload']['spec']['resources']['static_resources']
        }

        resources[resource_name]['url'] = resource_url
        resources[resource_name]['verification']['checksum'] = f'MD5:{resource_md5}'

    with open(args.deploy_conf, 'w') as ofd:
        yaml.dump(deploy_conf, ofd, default_flow_style=False)


if __name__ == '__main__':
    main()
